﻿namespace Hims.Api.Controllers
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Hims.Api.Utilities;
    using Hims.Domain.Services;
    using Hims.Shared.DataFilters;
    using Hims.Shared.EntityModels;
    using Hims.Shared.UserModels.Filters;
    using Hims.Api.Models;

    // ReSharper disable StyleCop.SA1126

    /// <summary>
    /// The pharmacy log controller.
    /// </summary>
    [Route("api/lab-log")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class LabLogController : BaseController
    {
        /// <summary>
        /// The pharmacy log service.
        /// </summary>
        private readonly ILabLogService labLogService;

        /// <inheritdoc />
        public LabLogController(ILabLogService labLogService) => this.labLogService = labLogService;



        /// <summary>
        /// To fetch pharmacy logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of pharmacy logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of pharmacyLogs.
        /// - 500 - Problem with Server side code.
        /// </remarks>

        [HttpPost]
        [Authorize]
        [Route("fetch-lab-logs")]
        [ProducesResponseType(typeof(IEnumerable<LabLogModel>), 200)]
        [ProducesResponseType(500)]

        public async Task<ActionResult> FetchAsync([FromBody] LabLogFilterModel model, [FromHeader] LocationHeader header)
        {
            model = (LabLogFilterModel)EmptyFilter.Handler(model);
            model.LocationId = Convert.ToInt32(header.LocationId);
            var labLogs = await labLogService.FetchAsync(model);
            if (labLogs == null)
            {
                return ServerError();
            }
            return Success(labLogs);
        }

        /// <summary>
        /// To insert pharmacy logs
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The list of pharmacy logs.
        /// </returns>
        /// <remarks>
        /// ### REMARKS ###
        /// The following codes are returned
        /// - 200 - List of pharmacyLogs.
        /// - 500 - Problem with Server side code.
        /// </remarks>

        [HttpPost]
        [Authorize]
        [Route("insert-lab-logs")]
        [ProducesResponseType(500)]
        public async Task<int> InsertAsync([FromBody] LabLogModel model, [FromHeader] LocationHeader header)
        {
            model = (LabLogModel)EmptyFilter.Handler(model);
            model.LogDate = DateTime.UtcNow;
            model.LocationId = Convert.ToInt32(header.LocationId);
            await labLogService.LogAsync(model);
            return 1;
        }
    }
}
